--
-- This file contains the sql and PL/SQL code to both generate XML from 
-- data within an Oracle table as well as to take an XML stream, parse it 
-- and insert the values into the table or update the existing values
-- if the row already exists.
--

set long 2000;

select xmlgen.getxml('select customer_id, name, city from demo.customer where customer_id < 200', 1) 
from dual;

create table scott.emp_insert_test as 
select * from scott.emp 
where 1=0;

-- Anonymous PL/SQL block to retrieve information from scott.emp
-- as an XML string and then use that string to insert the same
-- data into scott.emp_insert_test

declare 
  xmlString CLOB := null; 
  rows_ins integer; 
begin 
  xmlgen.setRowTag('EMP_ROW'); 

  -- use a lowercase tag names. 

  xmlgen.useLowerCaseTagNames(); 
  xmlgen.useNullAttributeIndicator(false); 
  xmlString := xmlgen.getXML('select * from scott.emp ',0); 
  
  -- open the lob 
  
  dbms_lob.open(xmlString,DBMS_LOB.LOB_READONLY); 
  
  xmlgen.resetOptions; 
  xmlgen.setRowTag('EMP_ROW'); 
  xmlgen.setIgnoreTagCase(xmlgen.IGNORE_CASE); 

  rows_ins := xmlgen.insertXML('scott.emp_insert_test',xmlString); 
  dbms_output.put_line(' Rows processed = '|| TO_CHAR(rows_ins)); 
  -- free the lob 
  dbms_lob.close(xmlString); 
  dbms_lob.freetemporary(xmlString); 

exception 
  when others then 
    xmlgen.resetOptions; 
    dbms_lob.close(xmlString); 
    dbms_lob.freetemporary(xmlString); 

end; 
/ 

-- Anonymous PL/SQL block that uses the xmlgen.updateXML procedure
-- give all employees in the scott.emp table a 20% raise.

declare 
  xmlString CLOB := null; 
  rows_updated integer; 
begin 
  xmlgen.setRowTag('EMP_ROW'); 

  xmlgen.useLowerCaseTagNames(); 
  xmlgen.useNullAttributeIndicator(false); 

  xmlString := xmlgen.getXML('select empno, ename, sal*1.20 as SAL 
                              from scott.emp',0); 
  
  dbms_lob.open(xmlString,DBMS_LOB.LOB_READONLY); 
  
  xmlgen.resetOptions; 
  xmlgen.setRowTag('EMP_ROW'); 
  xmlgen.setIgnoreTagCase(xmlgen.IGNORE_CASE); 

  -- set the key column to uniquely identify each row and
  -- the columns that are to be updated

  xmlgen.setKeyColumn('EMPNO');
  xmlgen.setUpdateColumn('SAL');

  -- update the database based on the XML document 

  rows_updated := xmlgen.updateXML('scott.emp',xmlString); 

  dbms_output.put_line('Rows processed = '|| TO_CHAR(rows_updated)); 
  -- free the lob 
  dbms_lob.close(xmlString); 
  dbms_lob.freetemporary(xmlString); 

  xmlgen.clearKeyColumnList;
  xmlgen.clearUpdateColumnList;

exception 
  when others then 
    xmlgen.resetOptions; 
    xmlgen.clearKeyColumnList;
    xmlgen.clearUpdateColumnList;
    dbms_lob.close(xmlString); 
    dbms_lob.freetemporary(xmlString); 

end; 
/
